/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEmptyIterableTest
extends AbstractMatcherTest {
    protected Matcher<Iterable<?>> createMatcher() {
        return IsEmptyIterable.emptyIterable();
    }

    public void testMatchesAnEmptyIterable() {
        IsEmptyIterableTest.assertMatches("empty iterable", this.createMatcher(), IsEmptyIterableTest.emptyCollection());
    }

    public void testDoesNotMatchAnIterableWithItems() {
        IsEmptyIterableTest.assertDoesNotMatch("iterable with an item", this.createMatcher(), IsEmptyIterableTest.collectionOfValues());
    }

    public void testHasAReadableDescription() {
        IsEmptyIterableTest.assertDescription("an empty iterable", this.createMatcher());
    }

    public void testCompiles() {
        this.needs((Matcher<Iterable<String>>)IsEmptyIterable.emptyIterableOf(String.class));
    }

    private void needs(Matcher<Iterable<String>> bar) {
    }

    private static Collection<String> collectionOfValues() {
        return new ArrayList<String>(Arrays.asList("one", "three"));
    }

    private static Collection<Integer> emptyCollection() {
        return new ArrayList<Integer>();
    }
}

